var CACHE_NAME = 'tytd-cache-v1';
var urlsToCache = [
  './',
  './css/styles.css',
  './css/bootstrap.min.css',
  './js/bootstrap.min.js',
  './js/main.js',
  './js/new_main.js',
  './js/search.js',
  './js/spa.js',
  './js/jquery.js',
  './search.html',
  './upload.html',
  './legacy.html'
];

self.addEventListener('install', function(event) {
  // Perform install steps
  event.waitUntil(
    caches.open(CACHE_NAME)
      .then(function(cache) {
        console.log('Opened cache');
        return cache.addAll(urlsToCache.map(url => new Request(url,{credentials: 'same-origin'})));
      })
  );
});
self.addEventListener('fetch',function(event) {
    event.respondWith(

      caches.match(event.request)
        .then(function(response) {
          // Cache hit - return response
          
          if (response) {
            return response;
          }
          return fetch(event.request);
        }
      )
    );
  });