﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using Dasync.Collections;
using youtube_downloader.Server.Functions;

namespace TessesYoutubeDownloader.Server.Models
{
   public class SavedPlaylist
    {
        public static async Task<SavedPlaylist> FromPlaylistId(Resolution res,YoutubeExplode.YoutubeClient ytc,YoutubeExplode.Playlists.PlaylistId id,Action<string,Resolution> addToQueue, Action<int, int, string,string> downloadThumbnail)
        {
            
            SavedPlaylist pl2 = new SavedPlaylist();
            pl2.Videos = new List<string>();
           try { 
           var pl=await ytc.Playlists.GetAsync(id);
            var a = pl.Author;
            pl2.AuthorChannelId = a.ChannelId;
            pl2.AuthorTitle = a.Title;
            pl2.Id= pl.Id;
            pl2.Description = pl.Description;
            pl2.Title = pl.Title;
           
            foreach (var thumb in pl.Thumbnails)
            {
                downloadThumbnail(thumb.Resolution.Width, thumb.Resolution.Height,id, thumb.Url);
            }
            try
            {
                await ytc.Playlists.GetVideosAsync(id).ForEachAsync((v) =>
               {

                   addToQueue(v.Id, res);
                   pl2.Videos.Add(v.Id);

               });
            }catch(Exception ex)
            {
                    Console.WriteLine(ex.Message);

                    _ = ex;
            }
        }catch(Exception ex2)
            {
                Console.WriteLine(ex2.Message);

                _ = ex2;
            }
            return pl2;
        }
        public List<string> Videos { get; set; }
        public string AuthorTitle { get; set; }
        public string AuthorChannelId { get; set; }
        public string Id { get; set; }
        public string Description { get; set; }
        public string Title { get; set; }
    }
}
